// DeadEasy Dopaminergic macro for ImageJ
// by Manuel Guillermo Forero. Faculty of Engineering. Universidad de Ibagué
// e-mail: mgforero@yahoo.es
//The minimum and maximum volume of the cell were fixed with a stack of 0.2075665*0.2075665*.3 

macro "DeadEasy Dopaminergic [d]"
{
run("Display..."," ");//Verifies the correct LUT in the image's options
getVoxelSize(w,h,d,unit);
//---------------------------------------------------------------------------------------------------------------------
Dialog.create("Meristem segmentation 3D");
Dialog.addNumber("Minimum admited h-max altitude (intensity):",2);
Dialog.addNumber("Maximum cell volume:",10000);
Dialog.show();
he=Dialog.getNumber();
maxVol=Dialog.getNumber();
//---------------------------------------------------------------------------------------------------------------------
title=getTitle();
run("Duplicate...","title=filtered duplicate");
run("Despeckle","stack");
run("Maximum...", "radius=2 stack");
run("Minimum...", "radius=2 stack");
run("Maximum 3D...","x=2 y=2 z=1");
run("Minimum 3D...","x=2 y=2 z=1");
run("Remove dark regions", "window=25 minimum_grey_level=10 minimum_threshold=60 stack");
run("Invert", "stack");
run("Fast hybrid hmax 3D","height="+he);
run("Duplicate...","title=h-extMax duplicate");
//-----------------------------------------------------------------------------
//Obtain extended-maxima transform
run("Fast hybrid dome 3D","height=5");//Gets the seeds, if h<20 there is many FP
//run("Fast hybrid dome 3D","height=20");//Gets the seeds, if h<20 there is many FP
run("Multiply...","stack value=255");
//-----------------------------------------------------------------------------
run("Label3D26C ");
selectWindow("h-extMax");
close();
selectWindow("Label 3D");
//---------------------------------------------------------------------------------------
//Mix seeds that are very close
//run("Conditional Dilation label 3D 26C", "maximal=10 labeled=[Label 3D] original="+title);
//Elimination of the background region (labeled with a 1), which makes a problem during watershed (label 0 is given to the meristem border and intersection between cells).
//Equivalent of elimination of the biggest region
run("VolumeFilter ","minimum=0 maximum=10000");
//-----------------------------------------------------------------------------
selectWindow("filtered");
run("Invert", "stack");
run("IFT Watershed 3D", "restricted seeds=[Label 3D] queue=LIFO");
selectWindow("Label 3D");
//run("Remove low gradient regions 3D", "threshold="+minGrad+" grey=filtered");
selectWindow("filtered");
close();
//---------------------------------------------------------------------------------------------------------------------
//Brightness adjustment
selectWindow("Label 3D");
a=0;
for (i=1; i<=nSlices; i++)
 {
          setSlice(i);
          getStatistics(area, mean,min,max);
          if (a<max)
	a=max;
}
setMinAndMax(0,a);
//---------------------------------------------------------------------------------------------------------------------
a=w*h*d;
minVol=300;//12.925155577/a;//12.925155577=1000*0.2075665*0.2075665*.3//MinVol=1000 voxels
//maxVol=773685*0.2075665*0.2075665*.3//=10000 voxels
run("VolumeFilter ", "minimum="+minVol+" maximum="+maxVol);//Eliminates object too small or big.
run("Cells filter", "original_image=["+title+"] labelled_image=[Label 3D] minimum=200");
setVoxelSize(w,h,d,unit);
run("001-Meristem-random");
}
